/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.champions.common.config;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import top.theillusivec4.champions.Champions;
import top.theillusivec4.champions.common.config.ChampionsConfig;

public class ConfigLoot {
    private static final RandomSource RAND = RandomSource.create();
    private static final Map<Integer, List<Data>> DROPS = new HashMap<Integer, List<Data>>();

    public static List<ItemStack> getLootDrops(int tier) {
        ArrayList data = new ArrayList(DROPS.getOrDefault(tier, new ArrayList()));
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        if (data.isEmpty()) {
            return drops;
        }
        int amount = ChampionsConfig.lootScaling ? tier : 1;
        block0: for (int i = 0; i < amount; ++i) {
            double totalWeight = 0.0;
            for (Data loot : data) {
                totalWeight += (double)loot.weight;
            }
            double random = RAND.nextDouble() * totalWeight;
            double countWeight = 0.0;
            for (Data loot : data) {
                if (!((countWeight += (double)loot.weight) >= random)) continue;
                drops.add(loot.getStack());
                continue block0;
            }
        }
        return drops;
    }

    public static void parse(List<? extends String> lootDrops) {
        HashMap<Integer, List> result = new HashMap<Integer, List>();
        for (String string : lootDrops) {
            int tier;
            String[] parsed = string.split(";");
            if (parsed.length <= 0) continue;
            int amount = 1;
            boolean enchant = false;
            int weight = 1;
            if (parsed.length < 2) {
                Champions.LOGGER.error("{} needs at least a tier and an item name", (Object)string);
                continue;
            }
            try {
                tier = Integer.parseInt(parsed[0]);
            }
            catch (NumberFormatException e) {
                Champions.LOGGER.error("{} is not a valid tier", (Object)parsed[0]);
                continue;
            }
            Optional item = BuiltInRegistries.ITEM.getOptional(ResourceLocation.parse((String)parsed[1]));
            if (item.isEmpty()) {
                Champions.LOGGER.error("Item not found! {}", (Object)parsed[1]);
                continue;
            }
            if (parsed.length > 2) {
                try {
                    amount = Integer.parseInt(parsed[2]);
                }
                catch (NumberFormatException e) {
                    Champions.LOGGER.error("{} is not a valid stack amount", (Object)parsed[2]);
                }
                if (parsed.length > 3) {
                    if (parsed[3].equalsIgnoreCase("true")) {
                        enchant = true;
                    }
                    if (parsed.length > 4) {
                        try {
                            weight = Integer.parseInt(parsed[4]);
                        }
                        catch (NumberFormatException e) {
                            Champions.LOGGER.error("{} is not a valid weight", (Object)parsed[4]);
                        }
                    }
                }
            }
            ItemStack stack = new ItemStack((ItemLike)item.get(), amount);
            result.computeIfAbsent(tier, list -> new ArrayList()).add(new Data(stack, enchant, weight));
        }
        DROPS.clear();
        DROPS.putAll(result);
    }

    private record Data(ItemStack stack, boolean enchant, int weight) {
        public ItemStack getStack() {
            ItemStack loot = this.stack.copy();
            if (this.enchant) {
                // empty if block
            }
            return loot;
        }
    }
}

