/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.champions.common.capability;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.common.util.INBTSerializable;
import org.jetbrains.annotations.UnknownNullability;
import top.theillusivec4.champions.Champions;
import top.theillusivec4.champions.api.IChampion;
import top.theillusivec4.champions.api.affix.IAffix;
import top.theillusivec4.champions.common.capability.AttachmentEventHandler;
import top.theillusivec4.champions.common.event.ChampionEventsHandler;
import top.theillusivec4.champions.common.rank.Rank;
import top.theillusivec4.champions.common.rank.RankManager;
import top.theillusivec4.champions.common.registry.ModAttachments;
import top.theillusivec4.champions.common.util.ChampionHelper;

public class ChampionAttachment {
    private static final String AFFIX_TAG = "affixes";
    private static final String TIER_TAG = "tier";
    private static final String DATA_TAG = "data";
    private static final String ID_TAG = "identifier";

    public static void register() {
        NeoForge.EVENT_BUS.register((Object)new AttachmentEventHandler());
        NeoForge.EVENT_BUS.register((Object)new ChampionEventsHandler());
    }

    public static Provider createProvider(LivingEntity livingEntity) {
        return new Provider(livingEntity);
    }

    public static Optional<IChampion> getAttachment(@Nullable Entity entity) {
        if (!ChampionHelper.isValidChampionEntity(entity)) {
            return Optional.empty();
        }
        return Optional.ofNullable(((Provider)entity.getData(ModAttachments.CHAMPION_ATTACHMENT)).champion);
    }

    public static class Provider
    implements INBTSerializable<CompoundTag> {
        private final IChampion champion;

        Provider(LivingEntity livingEntity) {
            this.champion = new Champion(livingEntity);
        }

        public @UnknownNullability CompoundTag serializeNBT(HolderLookup.Provider provider) {
            CompoundTag compoundNBT = new CompoundTag();
            IChampion.Server champion = this.champion.getServer();
            champion.getRank().ifPresent(rank -> compoundNBT.putInt(ChampionAttachment.TIER_TAG, rank.getTier()));
            List<IAffix> affixes = champion.getAffixes();
            ListTag list = new ListTag();
            affixes.forEach(affix -> {
                CompoundTag tag = new CompoundTag();
                String id = affix.getIdentifier().toString();
                tag.putString(ChampionAttachment.ID_TAG, id);
                tag.put(ChampionAttachment.DATA_TAG, (Tag)champion.getData(id));
                list.add((Object)tag);
            });
            compoundNBT.put(ChampionAttachment.AFFIX_TAG, (Tag)list);
            return compoundNBT;
        }

        public void deserializeNBT(HolderLookup.Provider provider, CompoundTag nbt) {
            IChampion.Server champion = this.champion.getServer();
            if (nbt.contains(ChampionAttachment.TIER_TAG)) {
                int tier = nbt.getInt(ChampionAttachment.TIER_TAG);
                champion.setRank(RankManager.getRank(tier));
            }
            if (nbt.contains(ChampionAttachment.AFFIX_TAG)) {
                ListTag list = nbt.getList(ChampionAttachment.AFFIX_TAG, 10);
                ArrayList<IAffix> affixes = new ArrayList<IAffix>();
                for (int i = 0; i < list.size(); ++i) {
                    CompoundTag tag = list.getCompound(i);
                    String id = tag.getString(ChampionAttachment.ID_TAG);
                    Champions.API.getAffix(id).ifPresent(affix -> {
                        affixes.add((IAffix)affix);
                        if (tag.contains(ChampionAttachment.DATA_TAG)) {
                            champion.setData(id, tag.getCompound(ChampionAttachment.DATA_TAG));
                        }
                    });
                }
                champion.setAffixes(affixes);
            }
        }
    }

    public static class Champion
    implements IChampion {
        private final LivingEntity champion;
        private final Client client;
        private final Server server;

        private Champion(LivingEntity livingEntity) {
            this.champion = livingEntity;
            this.client = new Client();
            this.server = new Server();
        }

        @Override
        public Client getClient() {
            return this.client;
        }

        @Override
        public Server getServer() {
            return this.server;
        }

        @Override
        public LivingEntity getLivingEntity() {
            return this.champion;
        }

        public static class Client
        implements IChampion.Client {
            private final List<IAffix> affixes = new ArrayList<IAffix>();
            private final Map<ResourceLocation, IAffix> idToAffix = new HashMap<ResourceLocation, IAffix>();
            private final Map<ResourceLocation, CompoundTag> data = new HashMap<ResourceLocation, CompoundTag>();
            private Tuple<Integer, String> rank = null;

            @Override
            public Optional<Tuple<Integer, String>> getRank() {
                return Optional.ofNullable(this.rank);
            }

            @Override
            public void setRank(Tuple<Integer, String> rank) {
                this.rank = rank;
            }

            @Override
            public List<IAffix> getAffixes() {
                return Collections.unmodifiableList(this.affixes);
            }

            @Override
            public void setAffixes(Set<ResourceLocation> affixes) {
                this.affixes.clear();
                for (ResourceLocation affix : affixes) {
                    Champions.API.getAffix(affix).ifPresent(val -> {
                        this.affixes.add((IAffix)val);
                        this.idToAffix.put(val.getIdentifier(), (IAffix)val);
                    });
                }
            }

            @Override
            public Optional<IAffix> getAffix(String id) {
                return Optional.ofNullable(this.idToAffix.get(ResourceLocation.parse((String)id)));
            }

            @Override
            public void setData(String identifier, CompoundTag data) {
                this.data.put(ResourceLocation.parse((String)identifier), data);
            }

            @Override
            public CompoundTag getData(String identifier) {
                return this.data.getOrDefault(ResourceLocation.parse((String)identifier), new CompoundTag());
            }
        }

        public static class Server
        implements IChampion.Server {
            private final Map<ResourceLocation, CompoundTag> data = new HashMap<ResourceLocation, CompoundTag>();
            private Rank rank = null;
            private List<IAffix> affixes = new ArrayList<IAffix>();

            @Override
            public Optional<Rank> getRank() {
                return Optional.ofNullable(this.rank);
            }

            @Override
            public void setRank(Rank rank) {
                this.rank = rank;
            }

            @Override
            public List<IAffix> getAffixes() {
                return Collections.unmodifiableList(this.affixes);
            }

            @Override
            public void setAffixes(List<IAffix> affixes) {
                this.affixes = affixes;
            }

            @Override
            public void setData(String identifier, CompoundTag data) {
                this.data.put(ResourceLocation.parse((String)identifier), data);
            }

            @Override
            public CompoundTag getData(String identifier) {
                return this.data.getOrDefault(ResourceLocation.parse((String)identifier), new CompoundTag());
            }
        }
    }
}

