/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.champions.common.affix.core;

import java.util.List;
import java.util.Optional;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.Nullable;
import top.theillusivec4.champions.Champions;
import top.theillusivec4.champions.api.IChampion;
import top.theillusivec4.champions.api.affix.IAffix;
import top.theillusivec4.champions.api.data.AffixCategory;
import top.theillusivec4.champions.api.data.AffixSetting;
import top.theillusivec4.champions.common.config.ChampionsConfig;
import top.theillusivec4.champions.common.config.ConfigEnums;
import top.theillusivec4.champions.common.network.SPacketSyncAffixData;

public abstract class AbstractBasicAffix
implements IAffix {
    public static final String DEFAULT_PREFIX = "affix.";
    protected AffixSetting setting = AffixSetting.empty();

    public static boolean canTarget(LivingEntity livingEntity, @Nullable LivingEntity target, boolean sightCheck) {
        if (target == null || !target.isAlive() || target instanceof ArmorStand || sightCheck && !AbstractBasicAffix.hasLineOfSight(livingEntity, target)) {
            return false;
        }
        AttributeInstance attributeInstance = livingEntity.getAttribute(Attributes.FOLLOW_RANGE);
        double range = attributeInstance == null ? 16.0 : attributeInstance.getValue();
        range = ChampionsConfig.affixTargetRange == 0.0 ? range : Math.min(range, ChampionsConfig.affixTargetRange);
        return (double)livingEntity.distanceTo((Entity)target) <= range;
    }

    private static boolean hasLineOfSight(LivingEntity livingEntity, LivingEntity target) {
        if (livingEntity instanceof Mob) {
            Mob mob = (Mob)livingEntity;
            return mob.getSensing().hasLineOfSight((Entity)target);
        }
        return livingEntity.hasLineOfSight((Entity)target);
    }

    @Override
    public ResourceLocation getIdentifier() {
        return Champions.API.getAffixId(this).orElseThrow();
    }

    public String toString() {
        return this.getIdentifier().toString();
    }

    @Override
    public AffixCategory getCategory() {
        return this.setting.category();
    }

    @Override
    public boolean isEnabled() {
        return this.setting.enabled();
    }

    @Override
    public ConfigEnums.Permission getMobPermission() {
        return this.setting.mobPermission().orElse(ConfigEnums.Permission.BLACKLIST);
    }

    @Override
    public String getPrefix() {
        return this.setting.prefix().orElse(DEFAULT_PREFIX);
    }

    @Override
    public void sync(IChampion champion) {
        LivingEntity livingEntity = champion.getLivingEntity();
        CompoundTag tag = this.writeSyncTag(champion);
        PacketDistributor.sendToPlayersTrackingEntity((Entity)livingEntity, (CustomPacketPayload)new SPacketSyncAffixData(livingEntity.getId(), this.toString(), tag), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    @Override
    public boolean canApply(IChampion champion) {
        ResourceLocation entityKey = BuiltInRegistries.ENTITY_TYPE.getKey((Object)champion.getLivingEntity().getType());
        boolean isValidEntity = this.isBlackList() ? this.getMobList().map(mobList -> !mobList.contains(entityKey)).orElse(true).booleanValue() : this.getMobList().map(mobList -> mobList.contains(entityKey)).orElse(false).booleanValue();
        return this.isEnabled() && isValidEntity && champion.getServer().getRank().map(rank -> this.getTier().matches(rank.getTier())).orElse(false) != false;
    }

    @Override
    public MinMaxBounds.Ints getTier() {
        return this.setting.tier().orElse(MinMaxBounds.Ints.atLeast((int)1));
    }

    @Override
    public Optional<List<ResourceLocation>> getMobList() {
        return this.setting.mobList();
    }

    @Override
    public AffixSetting getSetting() {
        if (this.setting == null) {
            this.setting = this.createDefaultSetting();
        }
        return this.setting;
    }

    @Override
    public void applySetting(AffixSetting affixSetting) {
        this.setting = affixSetting;
    }

    public void applyDefaultSettingWithId() {
        this.applySetting(this.createDefaultSetting().withNewType(this.getIdentifier()));
    }

    public boolean isBlackList() {
        return this.getMobPermission() == ConfigEnums.Permission.BLACKLIST;
    }

    public abstract AffixSetting createDefaultSetting();
}

