/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.champions.common.affix;

import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import top.theillusivec4.champions.api.IChampion;
import top.theillusivec4.champions.api.data.AffixCategory;
import top.theillusivec4.champions.api.data.AffixSetting;
import top.theillusivec4.champions.common.affix.core.CombatAffix;
import top.theillusivec4.champions.common.config.ChampionsConfig;
import top.theillusivec4.champions.common.registry.ModDamageTypes;

public class ReflectiveAffix
extends CombatAffix {
    @SubscribeEvent
    public void onDamageEvent(LivingDamageEvent.Pre evt) {
        if (!ChampionsConfig.reflectiveLethal && evt.getSource().is(ModDamageTypes.REFLECTION_DAMAGE)) {
            LivingEntity living = evt.getEntity();
            float currentDamage = evt.getOriginalDamage();
            if (currentDamage >= living.getHealth()) {
                evt.setNewDamage(living.getHealth() - 1.0f);
            }
        }
    }

    @Override
    public float onDamage(IChampion champion, DamageSource source, float amount, float newAmount) {
        Entity entity = source.getDirectEntity();
        if (entity instanceof LivingEntity) {
            LivingEntity sourceEntity = (LivingEntity)entity;
            if (source.is(ModDamageTypes.REFLECTION_DAMAGE) || source.is(DamageTypes.THORNS)) {
                return newAmount;
            }
            DamageSource newSource = ModDamageTypes.of(ModDamageTypes.REFLECTION_DAMAGE, (Entity)champion.getLivingEntity());
            if (source.getEntity() != null) {
                newSource = ModDamageTypes.of(ModDamageTypes.REFLECTION_DAMAGE, source.getDirectEntity(), (Entity)champion.getLivingEntity());
            }
            float min = (float)ChampionsConfig.reflectiveMinPercent;
            float damage = (float)Math.min((double)amount * ((double)sourceEntity.getRandom().nextFloat() * (ChampionsConfig.reflectiveMaxPercent - (double)min) + (double)min), (double)ChampionsConfig.reflectiveMax);
            sourceEntity.hurt(newSource, damage);
        }
        return newAmount;
    }

    @Override
    public AffixSetting createDefaultSetting() {
        return AffixSetting.builder().withDefault().setCategory(AffixCategory.OFFENSE).setHasSub().build();
    }
}

