/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.champions.common.affix;

import java.util.List;
import net.minecraft.core.particles.ColorParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import top.theillusivec4.champions.api.IChampion;
import top.theillusivec4.champions.api.data.AffixSetting;
import top.theillusivec4.champions.common.affix.core.AbstractBasicAffix;
import top.theillusivec4.champions.common.affix.core.CombatLifeCycleAffix;
import top.theillusivec4.champions.common.config.ChampionsConfig;

public class PlaguedAffix
extends CombatLifeCycleAffix {
    @Override
    public void onClientUpdate(IChampion champion) {
        LivingEntity livingEntity = champion.getLivingEntity();
        float radius = ChampionsConfig.plaguedRange;
        float circle = (float)Math.PI * radius * radius;
        int circleParticles = 0;
        while ((float)circleParticles < circle) {
            float f6 = livingEntity.getRandom().nextFloat() * ((float)Math.PI * 2);
            float randomRadiusSection = Mth.sqrt((float)livingEntity.getRandom().nextFloat()) * radius;
            float f8 = Mth.cos((float)f6) * randomRadiusSection;
            float f9 = Mth.sin((float)f6) * randomRadiusSection;
            int l1 = ((MobEffect)ChampionsConfig.plaguedEffect.getEffect().value()).getColor();
            int red = l1 >> 16 & 0xFF;
            int green = l1 >> 8 & 0xFF;
            int blue = l1 & 0xFF;
            livingEntity.level().addParticle((ParticleOptions)ColorParticleOption.create((ParticleType)ParticleTypes.ENTITY_EFFECT, (int)FastColor.ARGB32.color((int)125, (int)red, (int)green, (int)blue)), livingEntity.position().x + (double)f8, livingEntity.position().y, livingEntity.position().z + (double)f9, (double)red / 255.0, (double)green / 255.0, (double)blue / 255.0);
            ++circleParticles;
        }
    }

    @Override
    public void onServerUpdate(IChampion champion) {
        LivingEntity livingEntity = champion.getLivingEntity();
        if (livingEntity.tickCount % 10 == 0) {
            List list = livingEntity.level().getEntities((Entity)livingEntity, livingEntity.getBoundingBox().inflate((double)ChampionsConfig.plaguedRange), entity -> entity instanceof LivingEntity && AbstractBasicAffix.canTarget(livingEntity, (LivingEntity)entity, true));
            list.forEach(entity -> {
                if (entity instanceof LivingEntity) {
                    ((LivingEntity)entity).addEffect(new MobEffectInstance(ChampionsConfig.plaguedEffect.getEffect(), ChampionsConfig.plaguedEffect.getDuration(), ChampionsConfig.plaguedEffect.getAmplifier()));
                }
            });
            livingEntity.removeEffect(ChampionsConfig.plaguedEffect.getEffect());
        }
    }

    @Override
    public boolean onAttack(IChampion champion, LivingEntity target, DamageSource source, float amount) {
        target.addEffect(new MobEffectInstance(ChampionsConfig.plaguedEffect.getEffect(), ChampionsConfig.plaguedEffect.getDuration(), ChampionsConfig.plaguedEffect.getAmplifier()));
        return true;
    }

    @Override
    public AffixSetting createDefaultSetting() {
        return AffixSetting.builder().withDefault().build();
    }
}

