/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.champions.client.integration.theoneprobe;

import java.util.function.Function;
import mcjty.theoneprobe.api.Color;
import mcjty.theoneprobe.api.IProbeHitEntityData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.IProbeInfoEntityProvider;
import mcjty.theoneprobe.api.ITheOneProbe;
import mcjty.theoneprobe.api.ProbeMode;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.util.FastColor;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import top.theillusivec4.champions.api.IChampion;
import top.theillusivec4.champions.api.affix.IAffix;
import top.theillusivec4.champions.common.capability.ChampionAttachment;
import top.theillusivec4.champions.common.config.ChampionsConfig;
import top.theillusivec4.champions.common.util.ChampionHelper;

public class TheOneProbePlugin
implements IProbeInfoEntityProvider {
    public String getID() {
        return "champions:entity.champion";
    }

    public void addProbeEntityInfo(ProbeMode probeMode, IProbeInfo probeInfo, Player player, Level level, Entity entity, IProbeHitEntityData probeHitEntityData) {
        if (ChampionsConfig.enableTOPIntegration) {
            ChampionAttachment.getAttachment(entity).ifPresent(champion -> {
                IChampion.Server serverChampion = champion.getServer();
                if (!ChampionHelper.isValidChampion(serverChampion)) {
                    return;
                }
                serverChampion.getRank().ifPresent(rank -> {
                    TextColor color = rank.getDefaultColor();
                    int r = FastColor.ARGB32.red((int)color.getValue());
                    int g = FastColor.ARGB32.green((int)color.getValue());
                    int b = FastColor.ARGB32.blue((int)color.getValue());
                    Color rankColor = new Color(r, g, b);
                    IProbeInfo vertical = probeInfo.vertical(probeInfo.defaultLayoutStyle().borderColor(rankColor).spacing(3).padding(3));
                    vertical.mcText((Component)Component.translatable((String)("rank.champions.title." + rank.getTier())).append(" (" + rank.getTier() + ")").setStyle(Style.EMPTY.withUnderlined(Boolean.valueOf(true)).withColor(rank.getDefaultColor())));
                    for (IAffix affix : serverChampion.getAffixes()) {
                        IProbeInfo horizontal = vertical.horizontal();
                        horizontal.mcText((Component)Component.translatable((String)affix.toLanguageKey()));
                    }
                });
            });
        }
    }

    public static final class GetTheOneProbe
    implements Function<ITheOneProbe, Void> {
        @Override
        public Void apply(ITheOneProbe input) {
            TheOneProbePlugin instance = new TheOneProbePlugin();
            input.registerEntityProvider((IProbeInfoEntityProvider)instance);
            return null;
        }
    }
}

