/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.champions.client.config;

import net.neoforged.neoforge.common.ModConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class ClientChampionsConfig {
    public static final ModConfigSpec CLIENT_SPEC;
    public static final Client CLIENT;
    private static final String CONFIG_PREFIX = "gui.champions.config.";
    public static int jadeStarSpacing;
    public static int jadeStarBottomPadding;
    public static int hudXOffset;
    public static int hudYOffset;
    public static int hudRange;
    public static boolean enableWailaIntegration;

    public static void bake() {
        hudXOffset = (Integer)ClientChampionsConfig.CLIENT.hudXOffset.get();
        hudYOffset = (Integer)ClientChampionsConfig.CLIENT.hudYOffset.get();
        jadeStarSpacing = (Integer)ClientChampionsConfig.CLIENT.jadeStarSpacing.get();
        jadeStarBottomPadding = (Integer)ClientChampionsConfig.CLIENT.jadeStarBottomPadding.get();
        hudRange = (Integer)ClientChampionsConfig.CLIENT.hudRange.get();
        enableWailaIntegration = (Boolean)ClientChampionsConfig.CLIENT.enableWailaIntegration.get();
    }

    static {
        Pair specPair = new ModConfigSpec.Builder().configure(Client::new);
        CLIENT_SPEC = (ModConfigSpec)specPair.getRight();
        CLIENT = (Client)specPair.getLeft();
    }

    public static class Client {
        public final ModConfigSpec.IntValue hudXOffset;
        public final ModConfigSpec.IntValue hudYOffset;
        public final ModConfigSpec.IntValue hudRange;
        public final ModConfigSpec.BooleanValue enableWailaIntegration;
        public final ModConfigSpec.IntValue jadeStarSpacing;
        public final ModConfigSpec.IntValue jadeStarBottomPadding;

        public Client(ModConfigSpec.Builder builder) {
            builder.push("hud");
            this.hudXOffset = builder.comment("The x-offset for the champion HUD").translation("gui.champions.config.hudXOffset").defineInRange("hudXOffset", 0, -1000, 1000);
            this.hudYOffset = builder.comment("The y-offset for the champion HUD").translation("gui.champions.config.hudYOffset").defineInRange("hudYOffset", 0, -1000, 1000);
            this.hudRange = builder.comment("The distance, in blocks, from which the champion HUD can be seen").translation("gui.champions.config.hudRange").defineInRange("hudRange", 50, 0, 1000);
            this.enableWailaIntegration = builder.comment("Set to true to move the WAILA overlay underneath the champion HUD").translation("gui.champions.config.enableWailaIntegration").define("enableWailaIntegration", true);
            this.jadeStarSpacing = builder.comment("The Jade Star spacing, when rendering star.").defineInRange("jadeStarSpacing", 2, 0, 25);
            this.jadeStarBottomPadding = builder.comment("The Jade Star bottom padding, when rendering star.").defineInRange("jadeStarBottomPadding", 0, 0, 100);
            builder.pop();
        }
    }
}

