/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.champions.api.data;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.io.BufferedReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimplePreparableReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import top.theillusivec4.champions.Champions;
import top.theillusivec4.champions.api.data.AffixSetting;

public class AffixDataLoader
extends SimplePreparableReloadListener<Map<ResourceLocation, AffixSetting>> {
    private static final String FOLDER = "affix_setting";
    private final Map<ResourceLocation, AffixSetting> loadedData = new HashMap<ResourceLocation, AffixSetting>();

    protected Map<ResourceLocation, AffixSetting> prepare(ResourceManager resourceManager, ProfilerFiller profilerFiller) {
        return this.listResources(resourceManager, profilerFiller);
    }

    protected void apply(Map<ResourceLocation, AffixSetting> affixSettingMap, ResourceManager resourceManager, ProfilerFiller profilerFiller) {
        affixSettingMap.putAll(this.loadedData);
    }

    public Map<ResourceLocation, AffixSetting> listResources(ResourceManager pResourceManager, ProfilerFiller pProfiler) {
        pProfiler.startTick();
        for (Map.Entry resource : pResourceManager.listResources(FOLDER, p -> p.getPath().endsWith(".json")).entrySet()) {
            try {
                BufferedReader reader = ((Resource)resource.getValue()).openAsReader();
                try {
                    JsonElement element = JsonParser.parseReader((Reader)reader);
                    AffixSetting.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)element).resultOrPartial(error -> Champions.LOGGER.debug("Failed to parse affix setting {}", error)).ifPresent(itemValues -> this.loadedData.put((ResourceLocation)resource.getKey(), (AffixSetting)itemValues));
                }
                finally {
                    if (reader == null) continue;
                    ((Reader)reader).close();
                }
            }
            catch (Exception e) {
                Champions.LOGGER.error("Failed to load custom data pack: {}", resource.getKey(), (Object)e);
            }
        }
        pProfiler.endTick();
        return this.loadedData;
    }

    public void cache(Map<ResourceLocation, AffixSetting> affixSettings) {
        this.loadedData.clear();
        this.loadedData.putAll(affixSettings);
    }

    public static String getFolder() {
        return FOLDER;
    }

    public Map<ResourceLocation, AffixSetting> getLoadedData() {
        return this.loadedData;
    }
}

