/*
 * Decompiled with CFR 0.152.
 */
package net.fwykrin.tlmteleport;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Queue;
import java.util.Random;
import java.util.UUID;
import net.fwykrin.tlmteleport.ModConfig;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityTeleportEvent;
import net.minecraftforge.event.entity.EntityTravelToDimensionEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.server.ServerLifecycleHooks;

@Mod(value="tlmteleport")
public final class TlmTeleportCompanion {
    private static final ResourceLocation TLM_MAID_ID = ResourceLocation.fromNamespaceAndPath((String)"touhou_little_maid", (String)"maid");
    private static final Map<UUID, OriginInfo> ORIGIN = new HashMap<UUID, OriginInfo>();
    private static final Queue<PostPlace> POST_QUEUE = new ArrayDeque<PostPlace>();
    private static final Random RAND = new Random();
    private static final Map<UUID, SameDimFollowJob> SAME_DIM_JOBS = new HashMap<UUID, SameDimFollowJob>();

    public TlmTeleportCompanion() {
        try {
            ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)ModConfig.SPEC);
            MinecraftForge.EVENT_BUS.register((Object)this);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static boolean serverReady() {
        return ServerLifecycleHooks.getCurrentServer() != null;
    }

    private static boolean isTlmMaid(Entity ent) {
        ResourceLocation key = ent.m_6095_().m_204041_().m_205785_().m_135782_();
        if (!"touhou_little_maid".equals(key.m_135827_())) {
            return false;
        }
        String path = key.m_135815_().toLowerCase(Locale.ROOT);
        if (path.contains("maid")) {
            return true;
        }
        String cn = ent.getClass().getName().toLowerCase(Locale.ROOT);
        return cn.contains("maid");
    }

    private static void dbg(ServerPlayer sp, String msg) {
        if (!((Boolean)ModConfig.DEBUG.get()).booleanValue()) {
            return;
        }
        sp.m_5661_((Component)Component.m_237113_((String)"[TLMTP] ").m_130940_(ChatFormatting.GOLD).m_7220_((Component)Component.m_237113_((String)msg).m_130940_(ChatFormatting.YELLOW)), false);
    }

    private static boolean isFollowing(ServerPlayer sp, Entity ent) {
        if (!((Boolean)ModConfig.FOLLOWING_ONLY.get()).booleanValue()) {
            return true;
        }
        if (((Boolean)ModConfig.REQUIRE_LEASH_FOR_FOLLOW.get()).booleanValue() && ent instanceof Mob) {
            Mob mob = (Mob)ent;
            if (!mob.m_21523_()) {
                return false;
            }
            Entity holder = mob.m_21524_();
            return holder != null && holder.m_20148_().equals(sp.m_20148_());
        }
        if (ent instanceof TamableAnimal) {
            TamableAnimal ta = (TamableAnimal)ent;
            return !ta.m_21825_();
        }
        if (ent instanceof Mob) {
            Mob mob = (Mob)ent;
            return mob.m_21573_() != null && mob.m_21573_().m_26572_();
        }
        return true;
    }

    private static List<Entity> findOwnedMaidsNear(ServerLevel level, UUID playerId, Vec3 center, int radius) {
        AABB box = AABB.m_165882_((Vec3)center, (double)((double)radius * 2.0 + 1.0), (double)((double)radius * 2.0 + 1.0), (double)((double)radius * 2.0 + 1.0));
        return level.m_6443_(Entity.class, box, ent -> {
            if (!TlmTeleportCompanion.isTlmMaid(ent)) {
                return false;
            }
            if (ent instanceof OwnableEntity) {
                OwnableEntity own = (OwnableEntity)ent;
                UUID owner = own.m_21805_();
                return owner != null && owner.equals(playerId);
            }
            return false;
        });
    }

    private static void safeTeleportNear(Entity ent, ServerPlayer owner, int offXZ, int offY) {
        ServerLevel lvl = (ServerLevel)ent.m_9236_();
        Vec3 p = TlmTeleportCompanion.pickSafeSpawnNear(lvl, owner, offXZ, offY);
        ent.m_6021_(p.f_82479_, p.f_82480_, p.f_82481_);
        if (ent instanceof Mob) {
            Mob m = (Mob)ent;
            m.m_21573_().m_26573_();
        }
    }

    private static BlockPos findSafeStandPos(ServerLevel lvl, BlockPos center, int maxRadius, int maxUp, int maxDown) {
        int minY = lvl.m_141937_() + 1;
        int maxY = lvl.m_151558_() - 2;
        ArrayList<Integer> yOffsets = new ArrayList<Integer>();
        yOffsets.add(0);
        for (int i = 1; i <= Math.max(maxUp, maxDown); ++i) {
            if (i <= maxUp) {
                yOffsets.add(i);
            }
            if (i > maxDown) continue;
            yOffsets.add(-i);
        }
        for (int r = 0; r <= maxRadius; ++r) {
            for (int dx = -r; dx <= r; ++dx) {
                for (int dz = -r; dz <= r; ++dz) {
                    if (Math.max(Math.abs(dx), Math.abs(dz)) != r) continue;
                    Iterator iterator = yOffsets.iterator();
                    while (iterator.hasNext()) {
                        boolean airy;
                        BlockPos pos;
                        BlockPos below;
                        BlockState belowState;
                        int dy = (Integer)iterator.next();
                        int y = center.m_123342_() + dy;
                        if (y < minY || y > maxY || !(belowState = lvl.m_8055_(below = (pos = center.m_7918_(dx, 0, dz).m_175288_(y)).m_7495_())).m_60783_((BlockGetter)lvl, below, Direction.UP)) continue;
                        BlockState s0 = lvl.m_8055_(pos);
                        BlockState s1 = lvl.m_8055_(pos.m_7494_());
                        if (!s0.m_60819_().m_76178_() || !s1.m_60819_().m_76178_()) continue;
                        boolean bl = airy = !(!s0.m_60795_() && !s0.m_60812_((BlockGetter)lvl, pos).m_83281_() || !s1.m_60795_() && !s1.m_60812_((BlockGetter)lvl, pos.m_7494_()).m_83281_());
                        if (!airy) continue;
                        return pos;
                    }
                }
            }
        }
        int clampedY = Math.min(Math.max(center.m_123342_() + 1, minY), maxY);
        return new BlockPos(center.m_123341_(), clampedY, center.m_123343_());
    }

    private static Vec3 pickSafeSpawnNear(ServerLevel toLevel, ServerPlayer owner, int offXZ, int offY) {
        double ox = owner.m_20185_();
        double oy = owner.m_20186_();
        double oz = owner.m_20189_();
        double bx = ox + (double)(offXZ == 0 ? 0 : RAND.nextInt(offXZ * 2 + 1) - offXZ);
        double by = oy + (double)(offY == 0 ? 0 : RAND.nextInt(offY * 2 + 1) - offY);
        double bz = oz + (double)(offXZ == 0 ? 0 : RAND.nextInt(offXZ * 2 + 1) - offXZ);
        BlockPos center = BlockPos.m_274561_((double)bx, (double)by, (double)bz);
        BlockPos safe = TlmTeleportCompanion.findSafeStandPos(toLevel, center, 6, 6, 6);
        return Vec3.m_82512_((Vec3i)safe);
    }

    private static Entity fallbackCloneAcrossDimensions(Entity src, ServerLevel toLevel, ServerPlayer owner) {
        try {
            EntityType type = src.m_6095_();
            Entity fresh = type.m_20615_((Level)toLevel);
            if (fresh == null) {
                return null;
            }
            CompoundTag tag = new CompoundTag();
            src.m_20240_(tag);
            fresh.m_20258_(tag);
            int offXZ = Math.max(0, (Integer)ModConfig.POST_OFFSET_XZ.get());
            int offY = Math.max(0, (Integer)ModConfig.POST_OFFSET_Y.get());
            Vec3 p = TlmTeleportCompanion.pickSafeSpawnNear(toLevel, owner, offXZ, offY);
            fresh.m_7678_(p.f_82479_, p.f_82480_, p.f_82481_, src.m_146908_(), src.m_146909_());
            if (fresh instanceof Mob) {
                Mob m = (Mob)fresh;
                m.m_21561_(false);
                m.m_6710_(null);
                m.m_21573_().m_26573_();
            }
            if (!toLevel.m_7967_(fresh)) {
                return null;
            }
            src.m_146870_();
            return fresh;
        }
        catch (Throwable t) {
            return null;
        }
    }

    @SubscribeEvent
    public void onTravelToDimension(EntityTravelToDimensionEvent e) {
        try {
            Entity entity = e.getEntity();
            if (!(entity instanceof ServerPlayer)) {
                return;
            }
            ServerPlayer sp = (ServerPlayer)entity;
            Level lvl = sp.m_9236_();
            if (lvl.f_46443_) {
                return;
            }
            if (!TlmTeleportCompanion.serverReady()) {
                return;
            }
            ORIGIN.put(sp.m_20148_(), new OriginInfo(lvl.m_46472_().m_135782_(), sp.m_20182_()));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @SubscribeEvent
    public void onChangedDimension(PlayerEvent.PlayerChangedDimensionEvent e) {
        try {
            Player player = e.getEntity();
            if (!(player instanceof ServerPlayer)) {
                return;
            }
            ServerPlayer sp = (ServerPlayer)player;
            if (!TlmTeleportCompanion.serverReady()) {
                return;
            }
            MinecraftServer server = sp.f_8924_;
            OriginInfo info = ORIGIN.remove(sp.m_20148_());
            if (info == null) {
                return;
            }
            ServerLevel fromLevel = server.m_129880_(ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)info.dimKey));
            ServerLevel toLevel = server.m_129880_(e.getTo());
            if (fromLevel == null || toLevel == null) {
                return;
            }
            int radius = (Integer)ModConfig.SEARCH_RADIUS.get();
            int maxCnt = (Integer)ModConfig.MAX_TELEPORT_COUNT.get();
            List<Entity> candidates = TlmTeleportCompanion.findOwnedMaidsNear(fromLevel, sp.m_20148_(), info.pos, radius);
            TlmTeleportCompanion.dbg(sp, "candidates=" + candidates.size() + " radius=" + radius);
            int teleported = 0;
            for (Entity maid : candidates) {
                if (teleported >= maxCnt) break;
                if (!maid.m_6084_() || !(maid.m_9236_() instanceof ServerLevel)) continue;
                if (!TlmTeleportCompanion.isFollowing(sp, maid)) {
                    TlmTeleportCompanion.dbg(sp, "skip: not following");
                    continue;
                }
                try {
                    if (maid instanceof Mob) {
                        Mob mob = (Mob)maid;
                        if (mob.m_21523_()) {
                            mob.m_21455_(true, true);
                            TlmTeleportCompanion.dbg(sp, "dropped leash");
                        }
                        if (mob.m_20159_()) {
                            mob.m_8127_();
                            TlmTeleportCompanion.dbg(sp, "stopped riding");
                        }
                        mob.m_21561_(false);
                        mob.m_6710_(null);
                        mob.m_21573_().m_26573_();
                    }
                    if (!maid.m_6072_()) {
                        TlmTeleportCompanion.dbg(sp, "skip: cannotChangeDimensions");
                    } else {
                        Entity newEnt = maid.m_5489_(toLevel);
                        if (newEnt != null) {
                            POST_QUEUE.add(new PostPlace(newEnt.m_20148_(), toLevel.m_46472_().m_135782_(), sp.m_20148_()));
                            ++teleported;
                            TlmTeleportCompanion.dbg(sp, "queued x-dim maid");
                            continue;
                        }
                        TlmTeleportCompanion.dbg(sp, "changeDimension returned null (after cleanup)");
                    }
                    Entity cloned = TlmTeleportCompanion.fallbackCloneAcrossDimensions(maid, toLevel, sp);
                    if (cloned != null) {
                        POST_QUEUE.add(new PostPlace(cloned.m_20148_(), toLevel.m_46472_().m_135782_(), sp.m_20148_()));
                        ++teleported;
                        TlmTeleportCompanion.dbg(sp, "fallback clone spawned");
                        continue;
                    }
                    TlmTeleportCompanion.dbg(sp, "fallback failed");
                }
                catch (Throwable throwable) {}
            }
            TlmTeleportCompanion.dbg(sp, "teleported=" + teleported + "/" + maxCnt);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @SubscribeEvent
    public void onPlayerTeleportSameDim(EntityTeleportEvent e) {
        try {
            if (!((Boolean)ModConfig.ENABLE_SAME_DIMENSION_FOLLOW.get()).booleanValue()) {
                return;
            }
            Entity entity = e.getEntity();
            if (!(entity instanceof ServerPlayer)) {
                return;
            }
            ServerPlayer sp = (ServerPlayer)entity;
            if (sp.m_9236_().f_46443_) {
                return;
            }
            if (!TlmTeleportCompanion.serverReady()) {
                return;
            }
            ServerLevel level = (ServerLevel)sp.m_9236_();
            Vec3 origin = sp.m_20182_();
            Vec3 target = new Vec3(e.getTargetX(), e.getTargetY(), e.getTargetZ());
            SAME_DIM_JOBS.put(sp.m_20148_(), new SameDimFollowJob(sp.m_20148_(), level.m_46472_().m_135782_(), origin, target, (Integer)ModConfig.SEARCH_RADIUS.get(), (Integer)ModConfig.MAX_TELEPORT_COUNT.get()));
            TlmTeleportCompanion.dbg(sp, "queued same-dim follow job");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @SubscribeEvent
    public void onServerTick(TickEvent.ServerTickEvent e) {
        Mob mob;
        ServerPlayer owner;
        if (e.phase == TickEvent.Phase.END && !SAME_DIM_JOBS.isEmpty() && TlmTeleportCompanion.serverReady()) {
            MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
            ArrayList<SameDimFollowJob> jobs = new ArrayList<SameDimFollowJob>(SAME_DIM_JOBS.values());
            SAME_DIM_JOBS.clear();
            for (SameDimFollowJob job : jobs) {
                ServerLevel lvl = server.m_129880_(ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)job.dim));
                if (lvl == null || (owner = server.m_6846_().m_11259_(job.playerId)) == null) continue;
                int offXZ = Math.max(0, (Integer)ModConfig.POST_OFFSET_XZ.get());
                int offY = Math.max(0, (Integer)ModConfig.POST_OFFSET_Y.get());
                List<Entity> candidates = TlmTeleportCompanion.findOwnedMaidsNear(lvl, job.playerId, job.origin, job.radius);
                TlmTeleportCompanion.dbg(owner, "same-dim candidates=" + candidates.size() + " radius=" + job.radius);
                int moved = 0;
                for (Entity maid : candidates) {
                    if (moved >= job.max) break;
                    if (!maid.m_6084_()) continue;
                    if (!TlmTeleportCompanion.isFollowing(owner, maid)) {
                        TlmTeleportCompanion.dbg(owner, "same-dim skip: not following");
                        continue;
                    }
                    try {
                        if (maid instanceof Mob) {
                            mob = (Mob)maid;
                            if (mob.m_21523_()) {
                                mob.m_21455_(true, true);
                            }
                            if (mob.m_20159_()) {
                                mob.m_8127_();
                            }
                            mob.m_21561_(false);
                            mob.m_6710_(null);
                            mob.m_21573_().m_26573_();
                        }
                        BlockPos center = BlockPos.m_274561_((double)(job.target.f_82479_ + (double)(offXZ == 0 ? 0 : RAND.nextInt(offXZ * 2 + 1) - offXZ)), (double)(job.target.f_82480_ + (double)(offY == 0 ? 0 : RAND.nextInt(offY * 2 + 1) - offY)), (double)(job.target.f_82481_ + (double)(offXZ == 0 ? 0 : RAND.nextInt(offXZ * 2 + 1) - offXZ)));
                        BlockPos safe = TlmTeleportCompanion.findSafeStandPos(lvl, center, 6, 6, 6);
                        Vec3 p = Vec3.m_82512_((Vec3i)safe);
                        maid.m_6021_(p.f_82479_, p.f_82480_, p.f_82481_);
                        if (maid instanceof Mob) {
                            Mob m = (Mob)maid;
                            m.m_21573_().m_26573_();
                        }
                        ++moved;
                    }
                    catch (Throwable center) {}
                }
                TlmTeleportCompanion.dbg(owner, "same-dim moved=" + moved + "/" + job.max);
            }
        }
        try {
            PostPlace pp;
            if (e.phase != TickEvent.Phase.END) {
                return;
            }
            if (POST_QUEUE.isEmpty()) {
                return;
            }
            if (!TlmTeleportCompanion.serverReady()) {
                POST_QUEUE.clear();
                return;
            }
            int limit = Math.min(POST_QUEUE.size(), 32);
            MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
            if (server == null) {
                POST_QUEUE.clear();
                return;
            }
            for (int i = 0; i < limit && (pp = POST_QUEUE.poll()) != null; ++i) {
                Entity ent;
                ServerLevel toLevel = server.m_129880_(ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)pp.toDim));
                if (toLevel == null || (owner = server.m_6846_().m_11259_(pp.playerId)) == null || (ent = toLevel.m_8791_(pp.entityId)) == null) continue;
                int offXZ = Math.max(0, (Integer)ModConfig.POST_OFFSET_XZ.get());
                int offY = Math.max(0, (Integer)ModConfig.POST_OFFSET_Y.get());
                if (pp.toPosOverride != null) {
                    BlockPos center = BlockPos.m_274446_((Position)pp.toPosOverride);
                    BlockPos safe = TlmTeleportCompanion.findSafeStandPos(toLevel, center, 6, 6, 6);
                    Vec3 p = Vec3.m_82512_((Vec3i)safe);
                    ent.m_6021_(p.f_82479_, p.f_82480_, p.f_82481_);
                    if (!(ent instanceof Mob)) continue;
                    mob = (Mob)ent;
                    mob.m_21573_().m_26573_();
                    continue;
                }
                TlmTeleportCompanion.safeTeleportNear(ent, owner, offXZ, offY);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static final class OriginInfo {
        final ResourceLocation dimKey;
        final Vec3 pos;

        OriginInfo(ResourceLocation dimKey, Vec3 pos) {
            this.dimKey = dimKey;
            this.pos = pos;
        }
    }

    private static final class PostPlace {
        final UUID entityId;
        final ResourceLocation toDim;
        final UUID playerId;
        final Vec3 toPosOverride;

        PostPlace(UUID entityId, ResourceLocation toDim, UUID playerId) {
            this(entityId, toDim, playerId, null);
        }

        PostPlace(UUID entityId, ResourceLocation toDim, UUID playerId, Vec3 toPosOverride) {
            this.entityId = entityId;
            this.toDim = toDim;
            this.playerId = playerId;
            this.toPosOverride = toPosOverride;
        }
    }

    private static final class SameDimFollowJob {
        final UUID playerId;
        final ResourceLocation dim;
        final Vec3 origin;
        final Vec3 target;
        final int radius;
        final int max;

        SameDimFollowJob(UUID playerId, ResourceLocation dim, Vec3 origin, Vec3 target, int radius, int max) {
            this.playerId = playerId;
            this.dim = dim;
            this.origin = origin;
            this.target = target;
            this.radius = radius;
            this.max = max;
        }
    }
}

