/*
 * Decompiled with CFR 0.152.
 */
package net.fwykrin.tlmteleport;

import net.minecraftforge.common.ForgeConfigSpec;

public final class ModConfig {
    public static final ForgeConfigSpec SPEC;
    public static final ForgeConfigSpec.BooleanValue DEBUG;
    public static final ForgeConfigSpec.IntValue SEARCH_RADIUS;
    public static final ForgeConfigSpec.IntValue MAX_TELEPORT_COUNT;
    public static final ForgeConfigSpec.IntValue POST_OFFSET_XZ;
    public static final ForgeConfigSpec.IntValue POST_OFFSET_Y;
    public static final ForgeConfigSpec.BooleanValue FOLLOWING_ONLY;
    public static final ForgeConfigSpec.BooleanValue REQUIRE_LEASH_FOR_FOLLOW;
    public static final ForgeConfigSpec.BooleanValue ENABLE_SAME_DIMENSION_FOLLOW;

    private ModConfig() {
    }

    static {
        ForgeConfigSpec.Builder b = new ForgeConfigSpec.Builder();
        b.push("tlmteleport");
        DEBUG = b.comment("Print basic debug when picking candidate maids.").define("debug", false);
        SEARCH_RADIUS = b.comment("Search radius in the origin dimension (blocks)").defineInRange("searchRadius", 32, 4, 128);
        MAX_TELEPORT_COUNT = b.comment("Max maid count to teleport per change").defineInRange("maxTeleportCount", 10, 1, 64);
        POST_OFFSET_XZ = b.comment("Random placement offset on X/Z (\u00b1 blocks)").defineInRange("postOffsetXZ", 2, 0, 8);
        POST_OFFSET_Y = b.comment("Random placement offset on Y (\u00b1 blocks)").defineInRange("postOffsetY", 1, 0, 8);
        FOLLOWING_ONLY = b.comment("Teleport only maids that are in 'following' state (not sitting).").define("followingOnly", true);
        REQUIRE_LEASH_FOR_FOLLOW = b.comment("If true, treat 'following' as 'leashed to the player'. Most reliable.").define("requireLeashedForFollow", false);
        ENABLE_SAME_DIMENSION_FOLLOW = b.comment("Also follow when the player teleports within the same dimension (/tp, chorus, etc.)").define("enableSameDimensionFollow", true);
        b.pop();
        SPEC = b.build();
    }
}

