local M = {}

local function getRandom()
    local seed = os.time() * 1000 + math.floor(os.clock() * 1000)
    math.randomseed(seed)
    return math.random(1, 99)
end

function M.shoot(api)
    if (api:getAttachment("MUZZLE") == "immersive_armorer:muzzle_refit_extra_wires") then
        if (getRandom() < 26) then
            api:shootOnce(api:isShootingNeedConsumeAmmo())
            api:putAmmoInMagazine(1)
        else
            api:shootOnce(api:isShootingNeedConsumeAmmo())
        end
    else
        api:shootOnce(api:isShootingNeedConsumeAmmo())
    end
end

function M.start_reload(api)
    local cache = api:getCachedScriptData()
    if (cache == nil) then
        cache = {
            cleared = 0,
            feed = 0
        }
    end
    cache.cleared = 0
    cache.feed = 0
    api:cacheScriptData(cache)
    return true
end

function M.tick_reload(api)
    local reload_time = api:getReloadTime()
    local params = api:getScriptParams()
    local clear_time = params.clear_time * 1000
    local feed_time = params.feed_time * 1000
    local total_time = params.total_time * 1000
    local cache = api:getCachedScriptData()

    if (reload_time < clear_time) then
        return TACTICAL_RELOAD_FEEDING, clear_time - reload_time
    elseif (reload_time >= clear_time and reload_time < feed_time) then
        if (cache.cleared == 0) then
            api:removeAmmoFromMagazine(api:getMaxAmmoCount())
            api:setAmmoInBarrel(false)
            cache.cleared = 1
        end
        api:cacheScriptData(cache)
        return TACTICAL_RELOAD_FEEDING, feed_time - reload_time
    elseif (reload_time >= feed_time and reload_time <= total_time) then
        if (cache.feed == 0) then
            if (api:isShootingNeedConsumeAmmo()) then
                api:consumeAmmoFromPlayer(1)
                api:putAmmoInMagazine(api:getMaxAmmoCount())
                api:setAmmoInBarrel(true)
            else
                api:putAmmoInMagazine(api:getMaxAmmoCount())
                api:setAmmoInBarrel(true)
            end
            cache.feed = 1
        end
        api:cacheScriptData(cache)
        return TACTICAL_RELOAD_FINISHING, total_time - reload_time
    elseif (reload_time > total_time) then
        api:cacheScriptData(cache)
        return NOT_RELOADING, -1
    end
    api:cacheScriptData(cache)
end

return M